package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ComponentEvent(
    action: Optional[String] = Optional.Absent,
    parameters: Optional[zio.aws.amplifyuibuilder.model.ActionParameters] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ComponentEvent = {
    import ComponentEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentEvent
      .builder()
      .optionallyWith(action.map(value => value: java.lang.String))(_.action)
      .optionallyWith(parameters.map(value => value.buildAwsValue()))(
        _.parameters
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ComponentEvent.ReadOnly =
    zio.aws.amplifyuibuilder.model.ComponentEvent.wrap(buildAwsValue())
}
object ComponentEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ComponentEvent =
      zio.aws.amplifyuibuilder.model.ComponentEvent(
        action.map(value => value),
        parameters.map(value => value.asEditable)
      )
    def action: Optional[String]
    def parameters
        : Optional[zio.aws.amplifyuibuilder.model.ActionParameters.ReadOnly]
    def getAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("action", action)
    def getParameters: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ActionParameters.ReadOnly
    ] = AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentEvent
  ) extends zio.aws.amplifyuibuilder.model.ComponentEvent.ReadOnly {
    override val action: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.action())
      .map(value => value: String)
    override val parameters
        : Optional[zio.aws.amplifyuibuilder.model.ActionParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          zio.aws.amplifyuibuilder.model.ActionParameters.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentEvent
  ): zio.aws.amplifyuibuilder.model.ComponentEvent.ReadOnly = new Wrapper(impl)
}
