package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{
  ComponentName,
  Uuid,
  ComponentType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateComponentData(
    bindingProperties: Option[Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue
    ]] = None,
    children: Option[Iterable[zio.aws.amplifyuibuilder.model.ComponentChild]] =
      None,
    collectionProperties: Option[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentDataConfiguration]
    ] = None,
    componentType: Option[ComponentType] = None,
    events: Option[Map[String, zio.aws.amplifyuibuilder.model.ComponentEvent]] =
      None,
    id: Option[Uuid] = None,
    name: Option[ComponentName] = None,
    overrides: Option[Map[String, Map[String, String]]] = None,
    properties: Option[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentProperty]
    ] = None,
    schemaVersion: Option[String] = None,
    sourceId: Option[String] = None,
    variants: Option[
      Iterable[zio.aws.amplifyuibuilder.model.ComponentVariant]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentData = {
    import UpdateComponentData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentData
      .builder()
      .optionallyWith(
        bindingProperties.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.bindingProperties)
      .optionallyWith(
        children.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.children)
      .optionallyWith(
        collectionProperties.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.collectionProperties)
      .optionallyWith(
        componentType.map(value =>
          ComponentType.unwrap(value): java.lang.String
        )
      )(_.componentType)
      .optionallyWith(
        events.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.events)
      .optionallyWith(id.map(value => Uuid.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => ComponentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        overrides.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value
                .map({ case (key, value) =>
                  (key: java.lang.String) -> (value: java.lang.String)
                })
                .asJava
            })
            .asJava
        )
      )(_.overrides)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.properties)
      .optionallyWith(schemaVersion.map(value => value: java.lang.String))(
        _.schemaVersion
      )
      .optionallyWith(sourceId.map(value => value: java.lang.String))(
        _.sourceId
      )
      .optionallyWith(
        variants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.variants)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.UpdateComponentData.ReadOnly =
    zio.aws.amplifyuibuilder.model.UpdateComponentData.wrap(buildAwsValue())
}
object UpdateComponentData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.UpdateComponentData =
      zio.aws.amplifyuibuilder.model.UpdateComponentData(
        bindingProperties.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        children.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        collectionProperties.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        componentType.map(value => value),
        events.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        id.map(value => value),
        name.map(value => value),
        overrides.map(value => value),
        properties.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        schemaVersion.map(value => value),
        sourceId.map(value => value),
        variants.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def bindingProperties: Option[Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly
    ]]
    def children
        : Option[List[zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly]]
    def collectionProperties: Option[Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly
    ]]
    def componentType: Option[ComponentType]
    def events: Option[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentEvent.ReadOnly]
    ]
    def id: Option[Uuid]
    def name: Option[ComponentName]
    def overrides: Option[Map[String, Map[String, String]]]
    def properties: Option[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    ]
    def schemaVersion: Option[String]
    def sourceId: Option[String]
    def variants
        : Option[List[zio.aws.amplifyuibuilder.model.ComponentVariant.ReadOnly]]
    def getBindingProperties: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly
    ]] = AwsError.unwrapOptionField("bindingProperties", bindingProperties)
    def getChildren: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly
    ]] = AwsError.unwrapOptionField("children", children)
    def getCollectionProperties: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("collectionProperties", collectionProperties)
    def getComponentType: ZIO[Any, AwsError, ComponentType] =
      AwsError.unwrapOptionField("componentType", componentType)
    def getEvents: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("events", events)
    def getId: ZIO[Any, AwsError, Uuid] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ComponentName] =
      AwsError.unwrapOptionField("name", name)
    def getOverrides: ZIO[Any, AwsError, Map[String, Map[String, String]]] =
      AwsError.unwrapOptionField("overrides", overrides)
    def getProperties: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("properties", properties)
    def getSchemaVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getSourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceId", sourceId)
    def getVariants: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.ComponentVariant.ReadOnly
    ]] = AwsError.unwrapOptionField("variants", variants)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentData
  ) extends zio.aws.amplifyuibuilder.model.UpdateComponentData.ReadOnly {
    override val bindingProperties: Option[Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly
    ]] = scala
      .Option(impl.bindingProperties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue
              .wrap(value)
          })
          .toMap
      )
    override val children
        : Option[List[zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly]] =
      scala
        .Option(impl.children())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifyuibuilder.model.ComponentChild.wrap(item)
          }.toList
        )
    override val collectionProperties: Option[Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly
    ]] = scala
      .Option(impl.collectionProperties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.ComponentDataConfiguration
              .wrap(value)
          })
          .toMap
      )
    override val componentType: Option[ComponentType] = scala
      .Option(impl.componentType())
      .map(value =>
        zio.aws.amplifyuibuilder.model.primitives.ComponentType(value)
      )
    override val events: Option[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentEvent.ReadOnly]
    ] = scala
      .Option(impl.events())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.ComponentEvent
              .wrap(value)
          })
          .toMap
      )
    override val id: Option[Uuid] = scala
      .Option(impl.id())
      .map(value => zio.aws.amplifyuibuilder.model.primitives.Uuid(value))
    override val name: Option[ComponentName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.amplifyuibuilder.model.primitives.ComponentName(value)
      )
    override val overrides: Option[Map[String, Map[String, String]]] = scala
      .Option(impl.overrides())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> value.asScala
              .map({ case (key, value) =>
                (key: String) -> (value: String)
              })
              .toMap
          })
          .toMap
      )
    override val properties: Option[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    ] = scala
      .Option(impl.properties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.ComponentProperty
              .wrap(value)
          })
          .toMap
      )
    override val schemaVersion: Option[String] =
      scala.Option(impl.schemaVersion()).map(value => value: String)
    override val sourceId: Option[String] =
      scala.Option(impl.sourceId()).map(value => value: String)
    override val variants: Option[
      List[zio.aws.amplifyuibuilder.model.ComponentVariant.ReadOnly]
    ] = scala
      .Option(impl.variants())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplifyuibuilder.model.ComponentVariant.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentData
  ): zio.aws.amplifyuibuilder.model.UpdateComponentData.ReadOnly = new Wrapper(
    impl
  )
}
