package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateThemeRequest(
    appId: String,
    clientToken: Option[String] = None,
    environmentName: String,
    themeToCreate: zio.aws.amplifyuibuilder.model.CreateThemeData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeRequest = {
    import CreateThemeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeRequest
      .builder()
      .appId(appId: java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .environmentName(environmentName: java.lang.String)
      .themeToCreate(themeToCreate.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.CreateThemeRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.CreateThemeRequest.wrap(buildAwsValue())
}
object CreateThemeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.CreateThemeRequest =
      zio.aws.amplifyuibuilder.model.CreateThemeRequest(
        appId,
        clientToken.map(value => value),
        environmentName,
        themeToCreate.asEditable
      )
    def appId: String
    def clientToken: Option[String]
    def environmentName: String
    def themeToCreate: zio.aws.amplifyuibuilder.model.CreateThemeData.ReadOnly
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getThemeToCreate: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.CreateThemeData.ReadOnly
    ] = ZIO.succeed(themeToCreate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeRequest
  ) extends zio.aws.amplifyuibuilder.model.CreateThemeRequest.ReadOnly {
    override val appId: String = impl.appId(): String
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val environmentName: String = impl.environmentName(): String
    override val themeToCreate
        : zio.aws.amplifyuibuilder.model.CreateThemeData.ReadOnly =
      zio.aws.amplifyuibuilder.model.CreateThemeData.wrap(impl.themeToCreate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeRequest
  ): zio.aws.amplifyuibuilder.model.CreateThemeRequest.ReadOnly = new Wrapper(
    impl
  )
}
