package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateComponentResponse(
    entity: Option[zio.aws.amplifyuibuilder.model.Component] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentResponse = {
    import CreateComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentResponse
      .builder()
      .optionallyWith(entity.map(value => value.buildAwsValue()))(_.entity)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.CreateComponentResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.CreateComponentResponse.wrap(buildAwsValue())
}
object CreateComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.CreateComponentResponse =
      zio.aws.amplifyuibuilder.model
        .CreateComponentResponse(entity.map(value => value.asEditable))
    def entity: Option[zio.aws.amplifyuibuilder.model.Component.ReadOnly]
    def getEntity: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.Component.ReadOnly
    ] = AwsError.unwrapOptionField("entity", entity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentResponse
  ) extends zio.aws.amplifyuibuilder.model.CreateComponentResponse.ReadOnly {
    override val entity
        : Option[zio.aws.amplifyuibuilder.model.Component.ReadOnly] = scala
      .Option(impl.entity())
      .map(value => zio.aws.amplifyuibuilder.model.Component.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentResponse
  ): zio.aws.amplifyuibuilder.model.CreateComponentResponse.ReadOnly =
    new Wrapper(impl)
}
