package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{
  Integer,
  SyntheticExchangeCodeForTokenResponseString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ExchangeCodeForTokenResponse(
    accessToken: SyntheticExchangeCodeForTokenResponseString,
    expiresIn: Integer,
    refreshToken: SyntheticExchangeCodeForTokenResponseString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenResponse = {
    import ExchangeCodeForTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenResponse
      .builder()
      .accessToken(
        SyntheticExchangeCodeForTokenResponseString.unwrap(
          accessToken
        ): java.lang.String
      )
      .expiresIn(expiresIn: java.lang.Integer)
      .refreshToken(
        SyntheticExchangeCodeForTokenResponseString.unwrap(
          refreshToken
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenResponse
      .wrap(buildAwsValue())
}
object ExchangeCodeForTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenResponse =
      zio.aws.amplifyuibuilder.model
        .ExchangeCodeForTokenResponse(accessToken, expiresIn, refreshToken)
    def accessToken: SyntheticExchangeCodeForTokenResponseString
    def expiresIn: Integer
    def refreshToken: SyntheticExchangeCodeForTokenResponseString
    def getAccessToken
        : ZIO[Any, Nothing, SyntheticExchangeCodeForTokenResponseString] =
      ZIO.succeed(accessToken)
    def getExpiresIn: ZIO[Any, Nothing, Integer] = ZIO.succeed(expiresIn)
    def getRefreshToken
        : ZIO[Any, Nothing, SyntheticExchangeCodeForTokenResponseString] =
      ZIO.succeed(refreshToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenResponse
  ) extends zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenResponse.ReadOnly {
    override val accessToken: SyntheticExchangeCodeForTokenResponseString =
      zio.aws.amplifyuibuilder.model.primitives
        .SyntheticExchangeCodeForTokenResponseString(impl.accessToken())
    override val expiresIn: Integer = impl.expiresIn(): Integer
    override val refreshToken: SyntheticExchangeCodeForTokenResponseString =
      zio.aws.amplifyuibuilder.model.primitives
        .SyntheticExchangeCodeForTokenResponseString(impl.refreshToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenResponse
  ): zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenResponse.ReadOnly =
    new Wrapper(impl)
}
