package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ExportThemesResponse(
    entities: Iterable[zio.aws.amplifyuibuilder.model.Theme],
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse = {
    import ExportThemesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse
      .builder()
      .entities(entities.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ExportThemesResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.ExportThemesResponse.wrap(buildAwsValue())
}
object ExportThemesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ExportThemesResponse =
      zio.aws.amplifyuibuilder.model.ExportThemesResponse(
        entities.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def entities: List[zio.aws.amplifyuibuilder.model.Theme.ReadOnly]
    def nextToken: Option[String]
    def getEntities: ZIO[Any, Nothing, List[
      zio.aws.amplifyuibuilder.model.Theme.ReadOnly
    ]] = ZIO.succeed(entities)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse
  ) extends zio.aws.amplifyuibuilder.model.ExportThemesResponse.ReadOnly {
    override val entities: List[zio.aws.amplifyuibuilder.model.Theme.ReadOnly] =
      impl
        .entities()
        .asScala
        .map { item =>
          zio.aws.amplifyuibuilder.model.Theme.wrap(item)
        }
        .toList
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse
  ): zio.aws.amplifyuibuilder.model.ExportThemesResponse.ReadOnly = new Wrapper(
    impl
  )
}
