package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{
  SyntheticTimestamp_date_time,
  TagValue,
  Uuid,
  ThemeName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Theme(
    appId: String,
    createdAt: SyntheticTimestamp_date_time,
    environmentName: String,
    id: Uuid,
    modifiedAt: Option[SyntheticTimestamp_date_time] = None,
    name: ThemeName,
    overrides: Option[Iterable[zio.aws.amplifyuibuilder.model.ThemeValues]] =
      None,
    tags: Option[Map[TagKey, TagValue]] = None,
    values: Iterable[zio.aws.amplifyuibuilder.model.ThemeValues]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.Theme = {
    import Theme.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.Theme
      .builder()
      .appId(appId: java.lang.String)
      .createdAt(SyntheticTimestamp_date_time.unwrap(createdAt): Instant)
      .environmentName(environmentName: java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .optionallyWith(
        modifiedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.modifiedAt)
      .name(ThemeName.unwrap(name): java.lang.String)
      .optionallyWith(
        overrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.overrides)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .values(values.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.Theme.ReadOnly =
    zio.aws.amplifyuibuilder.model.Theme.wrap(buildAwsValue())
}
object Theme {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.Theme
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.Theme =
      zio.aws.amplifyuibuilder.model.Theme(
        appId,
        createdAt,
        environmentName,
        id,
        modifiedAt.map(value => value),
        name,
        overrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value),
        values.map { item =>
          item.asEditable
        }
      )
    def appId: String
    def createdAt: SyntheticTimestamp_date_time
    def environmentName: String
    def id: Uuid
    def modifiedAt: Option[SyntheticTimestamp_date_time]
    def name: ThemeName
    def overrides
        : Option[List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]]
    def tags: Option[Map[TagKey, TagValue]]
    def values: List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getCreatedAt: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(createdAt)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getModifiedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("modifiedAt", modifiedAt)
    def getName: ZIO[Any, Nothing, ThemeName] = ZIO.succeed(name)
    def getOverrides: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly
    ]] = AwsError.unwrapOptionField("overrides", overrides)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getValues: ZIO[Any, Nothing, List[
      zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly
    ]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.Theme
  ) extends zio.aws.amplifyuibuilder.model.Theme.ReadOnly {
    override val appId: String = impl.appId(): String
    override val createdAt: SyntheticTimestamp_date_time =
      zio.aws.amplifyuibuilder.model.primitives
        .SyntheticTimestamp_date_time(impl.createdAt())
    override val environmentName: String = impl.environmentName(): String
    override val id: Uuid =
      zio.aws.amplifyuibuilder.model.primitives.Uuid(impl.id())
    override val modifiedAt: Option[SyntheticTimestamp_date_time] = scala
      .Option(impl.modifiedAt())
      .map(value =>
        zio.aws.amplifyuibuilder.model.primitives
          .SyntheticTimestamp_date_time(value)
      )
    override val name: ThemeName =
      zio.aws.amplifyuibuilder.model.primitives.ThemeName(impl.name())
    override val overrides
        : Option[List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]] =
      scala
        .Option(impl.overrides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifyuibuilder.model.ThemeValues.wrap(item)
          }.toList
        )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplifyuibuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.amplifyuibuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val values
        : List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.amplifyuibuilder.model.ThemeValues.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.Theme
  ): zio.aws.amplifyuibuilder.model.Theme.ReadOnly = new Wrapper(impl)
}
