package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ComponentBindingPropertiesValue(
    bindingProperties: Option[
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties
    ] = None,
    defaultValue: Option[String] = None,
    `type`: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValue = {
    import ComponentBindingPropertiesValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValue
      .builder()
      .optionallyWith(bindingProperties.map(value => value.buildAwsValue()))(
        _.bindingProperties
      )
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly =
    zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue
      .wrap(buildAwsValue())
}
object ComponentBindingPropertiesValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue =
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue(
        bindingProperties.map(value => value.asEditable),
        defaultValue.map(value => value),
        `type`.map(value => value)
      )
    def bindingProperties: Option[
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties.ReadOnly
    ]
    def defaultValue: Option[String]
    def `type`: Option[String]
    def getBindingProperties: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties.ReadOnly
    ] = AwsError.unwrapOptionField("bindingProperties", bindingProperties)
    def getDefaultValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValue
  ) extends zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly {
    override val bindingProperties: Option[
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties.ReadOnly
    ] = scala
      .Option(impl.bindingProperties())
      .map(value =>
        zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties
          .wrap(value)
      )
    override val defaultValue: Option[String] =
      scala.Option(impl.defaultValue()).map(value => value: String)
    override val `type`: Option[String] =
      scala.Option(impl.`type`()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValue
  ): zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly =
    new Wrapper(impl)
}
