package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ComponentPropertyBindingProperties(
    field: Option[String] = None,
    property: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ComponentPropertyBindingProperties = {
    import ComponentPropertyBindingProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentPropertyBindingProperties
      .builder()
      .optionallyWith(field.map(value => value: java.lang.String))(_.field)
      .property(property: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties.ReadOnly =
    zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties
      .wrap(buildAwsValue())
}
object ComponentPropertyBindingProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentPropertyBindingProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties =
      zio.aws.amplifyuibuilder.model
        .ComponentPropertyBindingProperties(field.map(value => value), property)
    def field: Option[String]
    def property: String
    def getField: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("field", field)
    def getProperty: ZIO[Any, Nothing, String] = ZIO.succeed(property)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentPropertyBindingProperties
  ) extends zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties.ReadOnly {
    override val field: Option[String] =
      scala.Option(impl.field()).map(value => value: String)
    override val property: String = impl.property(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentPropertyBindingProperties
  ): zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties.ReadOnly =
    new Wrapper(impl)
}
