package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ComponentBindingPropertiesValueProperties(
    bucket: Option[String] = None,
    defaultValue: Option[String] = None,
    field: Option[String] = None,
    key: Option[String] = None,
    model: Option[String] = None,
    predicates: Option[Iterable[zio.aws.amplifyuibuilder.model.Predicate]] =
      None,
    userAttribute: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties = {
    import ComponentBindingPropertiesValueProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties
      .builder()
      .optionallyWith(bucket.map(value => value: java.lang.String))(_.bucket)
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .optionallyWith(field.map(value => value: java.lang.String))(_.field)
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(model.map(value => value: java.lang.String))(_.model)
      .optionallyWith(
        predicates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.predicates)
      .optionallyWith(userAttribute.map(value => value: java.lang.String))(
        _.userAttribute
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties.ReadOnly =
    zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties
      .wrap(buildAwsValue())
}
object ComponentBindingPropertiesValueProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties =
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties(
        bucket.map(value => value),
        defaultValue.map(value => value),
        field.map(value => value),
        key.map(value => value),
        model.map(value => value),
        predicates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userAttribute.map(value => value)
      )
    def bucket: Option[String]
    def defaultValue: Option[String]
    def field: Option[String]
    def key: Option[String]
    def model: Option[String]
    def predicates
        : Option[List[zio.aws.amplifyuibuilder.model.Predicate.ReadOnly]]
    def userAttribute: Option[String]
    def getBucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getDefaultValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getField: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("field", field)
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
    def getModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("model", model)
    def getPredicates: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.Predicate.ReadOnly
    ]] = AwsError.unwrapOptionField("predicates", predicates)
    def getUserAttribute: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userAttribute", userAttribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties
  ) extends zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties.ReadOnly {
    override val bucket: Option[String] =
      scala.Option(impl.bucket()).map(value => value: String)
    override val defaultValue: Option[String] =
      scala.Option(impl.defaultValue()).map(value => value: String)
    override val field: Option[String] =
      scala.Option(impl.field()).map(value => value: String)
    override val key: Option[String] =
      scala.Option(impl.key()).map(value => value: String)
    override val model: Option[String] =
      scala.Option(impl.model()).map(value => value: String)
    override val predicates
        : Option[List[zio.aws.amplifyuibuilder.model.Predicate.ReadOnly]] =
      scala
        .Option(impl.predicates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifyuibuilder.model.Predicate.wrap(item)
          }.toList
        )
    override val userAttribute: Option[String] =
      scala.Option(impl.userAttribute()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties
  ): zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties.ReadOnly =
    new Wrapper(impl)
}
