package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ComponentProperty(
    bindingProperties: Option[
      zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties
    ] = None,
    bindings: Option[
      Map[String, zio.aws.amplifyuibuilder.model.FormBindingElement]
    ] = None,
    collectionBindingProperties: Option[
      zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties
    ] = None,
    concat: Option[Iterable[zio.aws.amplifyuibuilder.model.ComponentProperty]] =
      None,
    condition: Option[
      zio.aws.amplifyuibuilder.model.ComponentConditionProperty
    ] = None,
    configured: Option[Boolean] = None,
    defaultValue: Option[String] = None,
    event: Option[String] = None,
    importedValue: Option[String] = None,
    model: Option[String] = None,
    `type`: Option[String] = None,
    userAttribute: Option[String] = None,
    value: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ComponentProperty = {
    import ComponentProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentProperty
      .builder()
      .optionallyWith(bindingProperties.map(value => value.buildAwsValue()))(
        _.bindingProperties
      )
      .optionallyWith(
        bindings.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.bindings)
      .optionallyWith(
        collectionBindingProperties.map(value => value.buildAwsValue())
      )(_.collectionBindingProperties)
      .optionallyWith(
        concat.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.concat)
      .optionallyWith(condition.map(value => value.buildAwsValue()))(
        _.condition
      )
      .optionallyWith(configured.map(value => value: java.lang.Boolean))(
        _.configured
      )
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .optionallyWith(event.map(value => value: java.lang.String))(_.event)
      .optionallyWith(importedValue.map(value => value: java.lang.String))(
        _.importedValue
      )
      .optionallyWith(model.map(value => value: java.lang.String))(_.model)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(userAttribute.map(value => value: java.lang.String))(
        _.userAttribute
      )
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly =
    zio.aws.amplifyuibuilder.model.ComponentProperty.wrap(buildAwsValue())
}
object ComponentProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ComponentProperty =
      zio.aws.amplifyuibuilder.model.ComponentProperty(
        bindingProperties.map(value => value.asEditable),
        bindings.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        collectionBindingProperties.map(value => value.asEditable),
        concat.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        condition.map(value => value.asEditable),
        configured.map(value => value),
        defaultValue.map(value => value),
        event.map(value => value),
        importedValue.map(value => value),
        model.map(value => value),
        `type`.map(value => value),
        userAttribute.map(value => value),
        value.map(value => value)
      )
    def bindingProperties: Option[
      zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties.ReadOnly
    ]
    def bindings: Option[
      Map[String, zio.aws.amplifyuibuilder.model.FormBindingElement.ReadOnly]
    ]
    def collectionBindingProperties: Option[
      zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties.ReadOnly
    ]
    def concat: Option[
      List[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    ]
    def condition: Option[
      zio.aws.amplifyuibuilder.model.ComponentConditionProperty.ReadOnly
    ]
    def configured: Option[Boolean]
    def defaultValue: Option[String]
    def event: Option[String]
    def importedValue: Option[String]
    def model: Option[String]
    def `type`: Option[String]
    def userAttribute: Option[String]
    def value: Option[String]
    def getBindingProperties: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties.ReadOnly
    ] = AwsError.unwrapOptionField("bindingProperties", bindingProperties)
    def getBindings: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.FormBindingElement.ReadOnly
    ]] = AwsError.unwrapOptionField("bindings", bindings)
    def getCollectionBindingProperties: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "collectionBindingProperties",
      collectionBindingProperties
    )
    def getConcat: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("concat", concat)
    def getCondition: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentConditionProperty.ReadOnly
    ] = AwsError.unwrapOptionField("condition", condition)
    def getConfigured: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("configured", configured)
    def getDefaultValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getEvent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("event", event)
    def getImportedValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("importedValue", importedValue)
    def getModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("model", model)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getUserAttribute: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userAttribute", userAttribute)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentProperty
  ) extends zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly {
    override val bindingProperties: Option[
      zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties.ReadOnly
    ] = scala
      .Option(impl.bindingProperties())
      .map(value =>
        zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties
          .wrap(value)
      )
    override val bindings: Option[
      Map[String, zio.aws.amplifyuibuilder.model.FormBindingElement.ReadOnly]
    ] = scala
      .Option(impl.bindings())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.FormBindingElement
              .wrap(value)
          })
          .toMap
      )
    override val collectionBindingProperties: Option[
      zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties.ReadOnly
    ] = scala
      .Option(impl.collectionBindingProperties())
      .map(value =>
        zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties
          .wrap(value)
      )
    override val concat: Option[
      List[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    ] = scala
      .Option(impl.concat())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplifyuibuilder.model.ComponentProperty.wrap(item)
        }.toList
      )
    override val condition: Option[
      zio.aws.amplifyuibuilder.model.ComponentConditionProperty.ReadOnly
    ] = scala
      .Option(impl.condition())
      .map(value =>
        zio.aws.amplifyuibuilder.model.ComponentConditionProperty.wrap(value)
      )
    override val configured: Option[Boolean] =
      scala.Option(impl.configured()).map(value => value: Boolean)
    override val defaultValue: Option[String] =
      scala.Option(impl.defaultValue()).map(value => value: String)
    override val event: Option[String] =
      scala.Option(impl.event()).map(value => value: String)
    override val importedValue: Option[String] =
      scala.Option(impl.importedValue()).map(value => value: String)
    override val model: Option[String] =
      scala.Option(impl.model()).map(value => value: String)
    override val `type`: Option[String] =
      scala.Option(impl.`type`()).map(value => value: String)
    override val userAttribute: Option[String] =
      scala.Option(impl.userAttribute()).map(value => value: String)
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentProperty
  ): zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly = new Wrapper(
    impl
  )
}
