package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class FormBindingElement(element: String, property: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.FormBindingElement = {
    import FormBindingElement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.FormBindingElement
      .builder()
      .element(element: java.lang.String)
      .property(property: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.FormBindingElement.ReadOnly =
    zio.aws.amplifyuibuilder.model.FormBindingElement.wrap(buildAwsValue())
}
object FormBindingElement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.FormBindingElement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.FormBindingElement =
      zio.aws.amplifyuibuilder.model.FormBindingElement(element, property)
    def element: String
    def property: String
    def getElement: ZIO[Any, Nothing, String] = ZIO.succeed(element)
    def getProperty: ZIO[Any, Nothing, String] = ZIO.succeed(property)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FormBindingElement
  ) extends zio.aws.amplifyuibuilder.model.FormBindingElement.ReadOnly {
    override val element: String = impl.element(): String
    override val property: String = impl.property(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FormBindingElement
  ): zio.aws.amplifyuibuilder.model.FormBindingElement.ReadOnly = new Wrapper(
    impl
  )
}
