package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ExportThemesRequest(appId: String, environmentName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesRequest = {
    import ExportThemesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesRequest
      .builder()
      .appId(appId: java.lang.String)
      .environmentName(environmentName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ExportThemesRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.ExportThemesRequest.wrap(buildAwsValue())
}
object ExportThemesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ExportThemesRequest =
      zio.aws.amplifyuibuilder.model.ExportThemesRequest(appId, environmentName)
    def appId: String
    def environmentName: String
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesRequest
  ) extends zio.aws.amplifyuibuilder.model.ExportThemesRequest.ReadOnly {
    override val appId: String = impl.appId(): String
    override val environmentName: String = impl.environmentName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesRequest
  ): zio.aws.amplifyuibuilder.model.ExportThemesRequest.ReadOnly = new Wrapper(
    impl
  )
}
