package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ExportComponentsResponse(
    entities: Iterable[zio.aws.amplifyuibuilder.model.Component]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse = {
    import ExportComponentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse
      .builder()
      .entities(entities.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ExportComponentsResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.ExportComponentsResponse
      .wrap(buildAwsValue())
}
object ExportComponentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ExportComponentsResponse =
      zio.aws.amplifyuibuilder.model.ExportComponentsResponse(entities.map {
        item =>
          item.asEditable
      })
    def entities: List[zio.aws.amplifyuibuilder.model.Component.ReadOnly]
    def getEntities: ZIO[Any, Nothing, List[
      zio.aws.amplifyuibuilder.model.Component.ReadOnly
    ]] = ZIO.succeed(entities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse
  ) extends zio.aws.amplifyuibuilder.model.ExportComponentsResponse.ReadOnly {
    override val entities
        : List[zio.aws.amplifyuibuilder.model.Component.ReadOnly] = impl
      .entities()
      .asScala
      .map { item =>
        zio.aws.amplifyuibuilder.model.Component.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse
  ): zio.aws.amplifyuibuilder.model.ExportComponentsResponse.ReadOnly =
    new Wrapper(impl)
}
