package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetThemeResponse(
    theme: Option[zio.aws.amplifyuibuilder.model.Theme] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.GetThemeResponse = {
    import GetThemeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.GetThemeResponse
      .builder()
      .optionallyWith(theme.map(value => value.buildAwsValue()))(_.theme)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.GetThemeResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.GetThemeResponse.wrap(buildAwsValue())
}
object GetThemeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.GetThemeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.GetThemeResponse =
      zio.aws.amplifyuibuilder.model
        .GetThemeResponse(theme.map(value => value.asEditable))
    def theme: Option[zio.aws.amplifyuibuilder.model.Theme.ReadOnly]
    def getTheme
        : ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.Theme.ReadOnly] =
      AwsError.unwrapOptionField("theme", theme)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.GetThemeResponse
  ) extends zio.aws.amplifyuibuilder.model.GetThemeResponse.ReadOnly {
    override val theme: Option[zio.aws.amplifyuibuilder.model.Theme.ReadOnly] =
      scala
        .Option(impl.theme())
        .map(value => zio.aws.amplifyuibuilder.model.Theme.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.GetThemeResponse
  ): zio.aws.amplifyuibuilder.model.GetThemeResponse.ReadOnly = new Wrapper(
    impl
  )
}
