package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ExportComponentsRequest(
    appId: String,
    environmentName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsRequest = {
    import ExportComponentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsRequest
      .builder()
      .appId(appId: java.lang.String)
      .environmentName(environmentName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ExportComponentsRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.ExportComponentsRequest.wrap(buildAwsValue())
}
object ExportComponentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ExportComponentsRequest =
      zio.aws.amplifyuibuilder.model
        .ExportComponentsRequest(appId, environmentName)
    def appId: String
    def environmentName: String
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsRequest
  ) extends zio.aws.amplifyuibuilder.model.ExportComponentsRequest.ReadOnly {
    override val appId: String = impl.appId(): String
    override val environmentName: String = impl.environmentName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsRequest
  ): zio.aws.amplifyuibuilder.model.ExportComponentsRequest.ReadOnly =
    new Wrapper(impl)
}
