package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ThemeValues(
    key: Option[String] = None,
    value: Option[zio.aws.amplifyuibuilder.model.ThemeValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues = {
    import ThemeValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly =
    zio.aws.amplifyuibuilder.model.ThemeValues.wrap(buildAwsValue())
}
object ThemeValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ThemeValues =
      zio.aws.amplifyuibuilder.model.ThemeValues(
        key.map(value => value),
        value.map(value => value.asEditable)
      )
    def key: Option[String]
    def value: Option[zio.aws.amplifyuibuilder.model.ThemeValue.ReadOnly]
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ThemeValue.ReadOnly
    ] = AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues
  ) extends zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly {
    override val key: Option[String] =
      scala.Option(impl.key()).map(value => value: String)
    override val value
        : Option[zio.aws.amplifyuibuilder.model.ThemeValue.ReadOnly] = scala
      .Option(impl.value())
      .map(value => zio.aws.amplifyuibuilder.model.ThemeValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues
  ): zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly = new Wrapper(impl)
}
