package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SectionalElement(
    `type`: String,
    position: Optional[zio.aws.amplifyuibuilder.model.FieldPosition] =
      Optional.Absent,
    text: Optional[String] = Optional.Absent,
    level: Optional[Integer] = Optional.Absent,
    orientation: Optional[String] = Optional.Absent,
    excluded: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.SectionalElement = {
    import SectionalElement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.SectionalElement
      .builder()
      .`type`(`type`: java.lang.String)
      .optionallyWith(position.map(value => value.buildAwsValue()))(_.position)
      .optionallyWith(text.map(value => value: java.lang.String))(_.text)
      .optionallyWith(level.map(value => value: java.lang.Integer))(_.level)
      .optionallyWith(orientation.map(value => value: java.lang.String))(
        _.orientation
      )
      .optionallyWith(excluded.map(value => value: java.lang.Boolean))(
        _.excluded
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly =
    zio.aws.amplifyuibuilder.model.SectionalElement.wrap(buildAwsValue())
}
object SectionalElement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.SectionalElement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.SectionalElement =
      zio.aws.amplifyuibuilder.model.SectionalElement(
        `type`,
        position.map(value => value.asEditable),
        text.map(value => value),
        level.map(value => value),
        orientation.map(value => value),
        excluded.map(value => value)
      )
    def `type`: String
    def position
        : Optional[zio.aws.amplifyuibuilder.model.FieldPosition.ReadOnly]
    def text: Optional[String]
    def level: Optional[Integer]
    def orientation: Optional[String]
    def excluded: Optional[Boolean]
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
    def getPosition: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.FieldPosition.ReadOnly
    ] = AwsError.unwrapOptionField("position", position)
    def getText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("text", text)
    def getLevel: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("level", level)
    def getOrientation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("orientation", orientation)
    def getExcluded: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("excluded", excluded)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.SectionalElement
  ) extends zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly {
    override val `type`: String = impl.`type`(): String
    override val position
        : Optional[zio.aws.amplifyuibuilder.model.FieldPosition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.position())
        .map(value => zio.aws.amplifyuibuilder.model.FieldPosition.wrap(value))
    override val text: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.text())
      .map(value => value: String)
    override val level: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.level())
      .map(value => value: Integer)
    override val orientation: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.orientation())
      .map(value => value: String)
    override val excluded: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.excluded())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.SectionalElement
  ): zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly = new Wrapper(
    impl
  )
}
