package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.SensitiveString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RefreshTokenRequestBody(
    token: SensitiveString,
    clientId: Optional[SensitiveString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenRequestBody = {
    import RefreshTokenRequestBody.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenRequestBody
      .builder()
      .token(SensitiveString.unwrap(token): java.lang.String)
      .optionallyWith(
        clientId.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.clientId)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.RefreshTokenRequestBody.ReadOnly =
    zio.aws.amplifyuibuilder.model.RefreshTokenRequestBody.wrap(buildAwsValue())
}
object RefreshTokenRequestBody {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenRequestBody
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.RefreshTokenRequestBody =
      zio.aws.amplifyuibuilder.model
        .RefreshTokenRequestBody(token, clientId.map(value => value))
    def token: SensitiveString
    def clientId: Optional[SensitiveString]
    def getToken: ZIO[Any, Nothing, SensitiveString] = ZIO.succeed(token)
    def getClientId: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("clientId", clientId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenRequestBody
  ) extends zio.aws.amplifyuibuilder.model.RefreshTokenRequestBody.ReadOnly {
    override val token: SensitiveString =
      zio.aws.amplifyuibuilder.model.primitives.SensitiveString(impl.token())
    override val clientId: Optional[SensitiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value =>
        zio.aws.amplifyuibuilder.model.primitives.SensitiveString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenRequestBody
  ): zio.aws.amplifyuibuilder.model.RefreshTokenRequestBody.ReadOnly =
    new Wrapper(impl)
}
