package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{
  TagValue,
  TagKey,
  FormName,
  Uuid
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Form(
    appId: String,
    environmentName: String,
    id: Uuid,
    name: FormName,
    formActionType: zio.aws.amplifyuibuilder.model.FormActionType,
    style: zio.aws.amplifyuibuilder.model.FormStyle,
    dataType: zio.aws.amplifyuibuilder.model.FormDataTypeConfig,
    fields: Map[String, zio.aws.amplifyuibuilder.model.FieldConfig],
    sectionalElements: Map[
      String,
      zio.aws.amplifyuibuilder.model.SectionalElement
    ],
    schemaVersion: String,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    cta: Optional[zio.aws.amplifyuibuilder.model.FormCTA] = Optional.Absent,
    labelDecorator: Optional[zio.aws.amplifyuibuilder.model.LabelDecorator] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.Form = {
    import Form.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.Form
      .builder()
      .appId(appId: java.lang.String)
      .environmentName(environmentName: java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .name(FormName.unwrap(name): java.lang.String)
      .formActionType(formActionType.unwrap)
      .style(style.buildAwsValue())
      .dataType(dataType.buildAwsValue())
      .fields(
        fields
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .sectionalElements(
        sectionalElements
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .schemaVersion(schemaVersion: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(cta.map(value => value.buildAwsValue()))(_.cta)
      .optionallyWith(labelDecorator.map(value => value.unwrap))(
        _.labelDecorator
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.Form.ReadOnly =
    zio.aws.amplifyuibuilder.model.Form.wrap(buildAwsValue())
}
object Form {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.Form
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.Form =
      zio.aws.amplifyuibuilder.model.Form(
        appId,
        environmentName,
        id,
        name,
        formActionType,
        style.asEditable,
        dataType.asEditable,
        fields.map({ case (key, value) =>
          key -> value.asEditable
        }),
        sectionalElements.map({ case (key, value) =>
          key -> value.asEditable
        }),
        schemaVersion,
        tags.map(value => value),
        cta.map(value => value.asEditable),
        labelDecorator.map(value => value)
      )
    def appId: String
    def environmentName: String
    def id: Uuid
    def name: FormName
    def formActionType: zio.aws.amplifyuibuilder.model.FormActionType
    def style: zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly
    def dataType: zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly
    def fields: Map[String, zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly]
    def sectionalElements
        : Map[String, zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly]
    def schemaVersion: String
    def tags: Optional[Map[TagKey, TagValue]]
    def cta: Optional[zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly]
    def labelDecorator: Optional[zio.aws.amplifyuibuilder.model.LabelDecorator]
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, FormName] = ZIO.succeed(name)
    def getFormActionType
        : ZIO[Any, Nothing, zio.aws.amplifyuibuilder.model.FormActionType] =
      ZIO.succeed(formActionType)
    def getStyle
        : ZIO[Any, Nothing, zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly] =
      ZIO.succeed(style)
    def getDataType: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly
    ] = ZIO.succeed(dataType)
    def getFields: ZIO[Any, Nothing, Map[
      String,
      zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly
    ]] = ZIO.succeed(fields)
    def getSectionalElements: ZIO[Any, Nothing, Map[
      String,
      zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly
    ]] = ZIO.succeed(sectionalElements)
    def getSchemaVersion: ZIO[Any, Nothing, String] = ZIO.succeed(schemaVersion)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCta
        : ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly] =
      AwsError.unwrapOptionField("cta", cta)
    def getLabelDecorator
        : ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.LabelDecorator] =
      AwsError.unwrapOptionField("labelDecorator", labelDecorator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.Form
  ) extends zio.aws.amplifyuibuilder.model.Form.ReadOnly {
    override val appId: String = impl.appId(): String
    override val environmentName: String = impl.environmentName(): String
    override val id: Uuid =
      zio.aws.amplifyuibuilder.model.primitives.Uuid(impl.id())
    override val name: FormName =
      zio.aws.amplifyuibuilder.model.primitives.FormName(impl.name())
    override val formActionType: zio.aws.amplifyuibuilder.model.FormActionType =
      zio.aws.amplifyuibuilder.model.FormActionType.wrap(impl.formActionType())
    override val style: zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly =
      zio.aws.amplifyuibuilder.model.FormStyle.wrap(impl.style())
    override val dataType
        : zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly =
      zio.aws.amplifyuibuilder.model.FormDataTypeConfig.wrap(impl.dataType())
    override val fields
        : Map[String, zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly] =
      impl
        .fields()
        .asScala
        .map({ case (key, value) =>
          (key: String) -> zio.aws.amplifyuibuilder.model.FieldConfig
            .wrap(value)
        })
        .toMap
    override val sectionalElements: Map[
      String,
      zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly
    ] = impl
      .sectionalElements()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.amplifyuibuilder.model.SectionalElement
          .wrap(value)
      })
      .toMap
    override val schemaVersion: String = impl.schemaVersion(): String
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplifyuibuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.amplifyuibuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val cta
        : Optional[zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cta())
        .map(value => zio.aws.amplifyuibuilder.model.FormCTA.wrap(value))
    override val labelDecorator
        : Optional[zio.aws.amplifyuibuilder.model.LabelDecorator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelDecorator())
        .map(value => zio.aws.amplifyuibuilder.model.LabelDecorator.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.Form
  ): zio.aws.amplifyuibuilder.model.Form.ReadOnly = new Wrapper(impl)
}
