package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComponentDataConfiguration(
    model: String,
    sort: Optional[Iterable[zio.aws.amplifyuibuilder.model.SortProperty]] =
      Optional.Absent,
    predicate: Optional[zio.aws.amplifyuibuilder.model.Predicate] =
      Optional.Absent,
    identifiers: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ComponentDataConfiguration = {
    import ComponentDataConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentDataConfiguration
      .builder()
      .model(model: java.lang.String)
      .optionallyWith(
        sort.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sort)
      .optionallyWith(predicate.map(value => value.buildAwsValue()))(
        _.predicate
      )
      .optionallyWith(
        identifiers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.identifiers)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly =
    zio.aws.amplifyuibuilder.model.ComponentDataConfiguration
      .wrap(buildAwsValue())
}
object ComponentDataConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentDataConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ComponentDataConfiguration =
      zio.aws.amplifyuibuilder.model.ComponentDataConfiguration(
        model,
        sort.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        predicate.map(value => value.asEditable),
        identifiers.map(value => value)
      )
    def model: String
    def sort
        : Optional[List[zio.aws.amplifyuibuilder.model.SortProperty.ReadOnly]]
    def predicate: Optional[zio.aws.amplifyuibuilder.model.Predicate.ReadOnly]
    def identifiers: Optional[List[String]]
    def getModel: ZIO[Any, Nothing, String] = ZIO.succeed(model)
    def getSort: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.SortProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("sort", sort)
    def getPredicate: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.Predicate.ReadOnly
    ] = AwsError.unwrapOptionField("predicate", predicate)
    def getIdentifiers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("identifiers", identifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentDataConfiguration
  ) extends zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly {
    override val model: String = impl.model(): String
    override val sort
        : Optional[List[zio.aws.amplifyuibuilder.model.SortProperty.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sort())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifyuibuilder.model.SortProperty.wrap(item)
          }.toList
        )
    override val predicate
        : Optional[zio.aws.amplifyuibuilder.model.Predicate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predicate())
        .map(value => zio.aws.amplifyuibuilder.model.Predicate.wrap(value))
    override val identifiers: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.identifiers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentDataConfiguration
  ): zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly =
    new Wrapper(impl)
}
