package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComponentBindingPropertiesValueProperties(
    model: Optional[String] = Optional.Absent,
    field: Optional[String] = Optional.Absent,
    predicates: Optional[Iterable[zio.aws.amplifyuibuilder.model.Predicate]] =
      Optional.Absent,
    userAttribute: Optional[String] = Optional.Absent,
    bucket: Optional[String] = Optional.Absent,
    key: Optional[String] = Optional.Absent,
    defaultValue: Optional[String] = Optional.Absent,
    slotName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties = {
    import ComponentBindingPropertiesValueProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties
      .builder()
      .optionallyWith(model.map(value => value: java.lang.String))(_.model)
      .optionallyWith(field.map(value => value: java.lang.String))(_.field)
      .optionallyWith(
        predicates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.predicates)
      .optionallyWith(userAttribute.map(value => value: java.lang.String))(
        _.userAttribute
      )
      .optionallyWith(bucket.map(value => value: java.lang.String))(_.bucket)
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .optionallyWith(slotName.map(value => value: java.lang.String))(
        _.slotName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties.ReadOnly =
    zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties
      .wrap(buildAwsValue())
}
object ComponentBindingPropertiesValueProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties =
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties(
        model.map(value => value),
        field.map(value => value),
        predicates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userAttribute.map(value => value),
        bucket.map(value => value),
        key.map(value => value),
        defaultValue.map(value => value),
        slotName.map(value => value)
      )
    def model: Optional[String]
    def field: Optional[String]
    def predicates
        : Optional[List[zio.aws.amplifyuibuilder.model.Predicate.ReadOnly]]
    def userAttribute: Optional[String]
    def bucket: Optional[String]
    def key: Optional[String]
    def defaultValue: Optional[String]
    def slotName: Optional[String]
    def getModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("model", model)
    def getField: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("field", field)
    def getPredicates: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.Predicate.ReadOnly
    ]] = AwsError.unwrapOptionField("predicates", predicates)
    def getUserAttribute: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userAttribute", userAttribute)
    def getBucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
    def getDefaultValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getSlotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slotName", slotName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties
  ) extends zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties.ReadOnly {
    override val model: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.model())
      .map(value => value: String)
    override val field: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.field())
      .map(value => value: String)
    override val predicates
        : Optional[List[zio.aws.amplifyuibuilder.model.Predicate.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predicates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifyuibuilder.model.Predicate.wrap(item)
          }.toList
        )
    override val userAttribute: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userAttribute())
      .map(value => value: String)
    override val bucket: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => value: String)
    override val key: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => value: String)
    override val defaultValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValue())
      .map(value => value: String)
    override val slotName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.slotName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties
  ): zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties.ReadOnly =
    new Wrapper(impl)
}
