package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CodegenJobAsset(
    downloadUrl: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobAsset = {
    import CodegenJobAsset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobAsset
      .builder()
      .optionallyWith(downloadUrl.map(value => value: java.lang.String))(
        _.downloadUrl
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.CodegenJobAsset.ReadOnly =
    zio.aws.amplifyuibuilder.model.CodegenJobAsset.wrap(buildAwsValue())
}
object CodegenJobAsset {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobAsset
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.CodegenJobAsset =
      zio.aws.amplifyuibuilder.model
        .CodegenJobAsset(downloadUrl.map(value => value))
    def downloadUrl: Optional[String]
    def getDownloadUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("downloadUrl", downloadUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobAsset
  ) extends zio.aws.amplifyuibuilder.model.CodegenJobAsset.ReadOnly {
    override val downloadUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.downloadUrl())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobAsset
  ): zio.aws.amplifyuibuilder.model.CodegenJobAsset.ReadOnly = new Wrapper(impl)
}
