package zio.aws.amplifyuibuilder.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.amplifyuibuilder.model.primitives.{
  SyntheticTimestamp_date_time,
  Uuid,
  AppId
}
import scala.jdk.CollectionConverters._
final case class CodegenJobSummary(
    appId: AppId,
    environmentName: String,
    id: Uuid,
    createdAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    modifiedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobSummary = {
    import CodegenJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobSummary
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .environmentName(environmentName: java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .optionallyWith(
        createdAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAt)
      .optionallyWith(
        modifiedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.modifiedAt)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.CodegenJobSummary.ReadOnly =
    zio.aws.amplifyuibuilder.model.CodegenJobSummary.wrap(buildAwsValue())
}
object CodegenJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.CodegenJobSummary =
      zio.aws.amplifyuibuilder.model.CodegenJobSummary(
        appId,
        environmentName,
        id,
        createdAt.map(value => value),
        modifiedAt.map(value => value)
      )
    def appId: AppId
    def environmentName: String
    def id: Uuid
    def createdAt: Optional[SyntheticTimestamp_date_time]
    def modifiedAt: Optional[SyntheticTimestamp_date_time]
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getCreatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getModifiedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("modifiedAt", modifiedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobSummary
  ) extends zio.aws.amplifyuibuilder.model.CodegenJobSummary.ReadOnly {
    override val appId: AppId =
      zio.aws.amplifyuibuilder.model.primitives.AppId(impl.appId())
    override val environmentName: String = impl.environmentName(): String
    override val id: Uuid =
      zio.aws.amplifyuibuilder.model.primitives.Uuid(impl.id())
    override val createdAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAt())
        .map(value =>
          zio.aws.amplifyuibuilder.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val modifiedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modifiedAt())
        .map(value =>
          zio.aws.amplifyuibuilder.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobSummary
  ): zio.aws.amplifyuibuilder.model.CodegenJobSummary.ReadOnly = new Wrapper(
    impl
  )
}
