package zio.aws.amplifyuibuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.amplifyuibuilder.model.primitives.ListFormsLimit
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListFormsRequest(
    appId: String,
    environmentName: String,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[ListFormsLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsRequest = {
    import ListFormsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsRequest
      .builder()
      .appId(appId: java.lang.String)
      .environmentName(environmentName: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => ListFormsLimit.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ListFormsRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.ListFormsRequest.wrap(buildAwsValue())
}
object ListFormsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ListFormsRequest =
      zio.aws.amplifyuibuilder.model.ListFormsRequest(
        appId,
        environmentName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def appId: String
    def environmentName: String
    def nextToken: Optional[String]
    def maxResults: Optional[ListFormsLimit]
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListFormsLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsRequest
  ) extends zio.aws.amplifyuibuilder.model.ListFormsRequest.ReadOnly {
    override val appId: String = impl.appId(): String
    override val environmentName: String = impl.environmentName(): String
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[ListFormsLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.amplifyuibuilder.model.primitives.ListFormsLimit(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsRequest
  ): zio.aws.amplifyuibuilder.model.ListFormsRequest.ReadOnly = new Wrapper(
    impl
  )
}
