package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FieldPosition(
    fixed: Optional[zio.aws.amplifyuibuilder.model.FixedPosition] =
      Optional.Absent,
    rightOf: Optional[String] = Optional.Absent,
    below: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.FieldPosition = {
    import FieldPosition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.FieldPosition
      .builder()
      .optionallyWith(fixed.map(value => value.unwrap))(_.fixed)
      .optionallyWith(rightOf.map(value => value: java.lang.String))(_.rightOf)
      .optionallyWith(below.map(value => value: java.lang.String))(_.below)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.FieldPosition.ReadOnly =
    zio.aws.amplifyuibuilder.model.FieldPosition.wrap(buildAwsValue())
}
object FieldPosition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.FieldPosition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.FieldPosition =
      zio.aws.amplifyuibuilder.model.FieldPosition(
        fixed.map(value => value),
        rightOf.map(value => value),
        below.map(value => value)
      )
    def fixed: Optional[zio.aws.amplifyuibuilder.model.FixedPosition]
    def rightOf: Optional[String]
    def below: Optional[String]
    def getFixed
        : ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.FixedPosition] =
      AwsError.unwrapOptionField("fixed", fixed)
    def getRightOf: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rightOf", rightOf)
    def getBelow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("below", below)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FieldPosition
  ) extends zio.aws.amplifyuibuilder.model.FieldPosition.ReadOnly {
    override val fixed: Optional[zio.aws.amplifyuibuilder.model.FixedPosition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fixed())
        .map(value => zio.aws.amplifyuibuilder.model.FixedPosition.wrap(value))
    override val rightOf: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.rightOf())
      .map(value => value: String)
    override val below: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.below())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FieldPosition
  ): zio.aws.amplifyuibuilder.model.FieldPosition.ReadOnly = new Wrapper(impl)
}
