package zio.aws.amplifyuibuilder.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.amplifyuibuilder.model.primitives.{
  SyntheticTimestamp_date_time,
  TagValue,
  Uuid,
  ThemeName,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class Theme(
    appId: String,
    environmentName: String,
    id: Uuid,
    name: ThemeName,
    createdAt: SyntheticTimestamp_date_time,
    modifiedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    values: Iterable[zio.aws.amplifyuibuilder.model.ThemeValues],
    overrides: Optional[Iterable[zio.aws.amplifyuibuilder.model.ThemeValues]] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.Theme = {
    import Theme.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.Theme
      .builder()
      .appId(appId: java.lang.String)
      .environmentName(environmentName: java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .name(ThemeName.unwrap(name): java.lang.String)
      .createdAt(SyntheticTimestamp_date_time.unwrap(createdAt): Instant)
      .optionallyWith(
        modifiedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.modifiedAt)
      .values(values.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        overrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.overrides)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.Theme.ReadOnly =
    zio.aws.amplifyuibuilder.model.Theme.wrap(buildAwsValue())
}
object Theme {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.Theme
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.Theme =
      zio.aws.amplifyuibuilder.model.Theme(
        appId,
        environmentName,
        id,
        name,
        createdAt,
        modifiedAt.map(value => value),
        values.map { item =>
          item.asEditable
        },
        overrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value)
      )
    def appId: String
    def environmentName: String
    def id: Uuid
    def name: ThemeName
    def createdAt: SyntheticTimestamp_date_time
    def modifiedAt: Optional[SyntheticTimestamp_date_time]
    def values: List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]
    def overrides
        : Optional[List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]]
    def tags: Optional[Map[TagKey, TagValue]]
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, ThemeName] = ZIO.succeed(name)
    def getCreatedAt: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(createdAt)
    def getModifiedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("modifiedAt", modifiedAt)
    def getValues: ZIO[Any, Nothing, List[
      zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly
    ]] = ZIO.succeed(values)
    def getOverrides: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly
    ]] = AwsError.unwrapOptionField("overrides", overrides)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.Theme
  ) extends zio.aws.amplifyuibuilder.model.Theme.ReadOnly {
    override val appId: String = impl.appId(): String
    override val environmentName: String = impl.environmentName(): String
    override val id: Uuid =
      zio.aws.amplifyuibuilder.model.primitives.Uuid(impl.id())
    override val name: ThemeName =
      zio.aws.amplifyuibuilder.model.primitives.ThemeName(impl.name())
    override val createdAt: SyntheticTimestamp_date_time =
      zio.aws.amplifyuibuilder.model.primitives
        .SyntheticTimestamp_date_time(impl.createdAt())
    override val modifiedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modifiedAt())
        .map(value =>
          zio.aws.amplifyuibuilder.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val values
        : List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.amplifyuibuilder.model.ThemeValues.wrap(item)
      }
      .toList
    override val overrides
        : Optional[List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overrides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifyuibuilder.model.ThemeValues.wrap(item)
          }.toList
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplifyuibuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.amplifyuibuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.Theme
  ): zio.aws.amplifyuibuilder.model.Theme.ReadOnly = new Wrapper(impl)
}
