package zio.aws.amplifyuibuilder.model
import scala.jdk.CollectionConverters._
sealed trait CodegenJobGenericDataSourceType {
  def unwrap: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobGenericDataSourceType
}
object CodegenJobGenericDataSourceType {
  def wrap(
      value: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobGenericDataSourceType
  ): zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSourceType =
    value match {
      case software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobGenericDataSourceType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobGenericDataSourceType.DATA_STORE =>
        val r = DataStore
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobGenericDataSourceType =
      software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobGenericDataSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object DataStore
      extends zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobGenericDataSourceType =
      software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobGenericDataSourceType.DATA_STORE
  }
}
