package zio.aws.amplifyuibuilder.model
import scala.jdk.CollectionConverters._
sealed trait JSTarget {
  def unwrap: software.amazon.awssdk.services.amplifyuibuilder.model.JSTarget
}
object JSTarget {
  def wrap(
      value: software.amazon.awssdk.services.amplifyuibuilder.model.JSTarget
  ): zio.aws.amplifyuibuilder.model.JSTarget = value match {
    case software.amazon.awssdk.services.amplifyuibuilder.model.JSTarget.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifyuibuilder.model.JSTarget.ES2015 =>
      val r = es2015
      r
    case software.amazon.awssdk.services.amplifyuibuilder.model.JSTarget.ES2020 =>
      val r = es2020
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.amplifyuibuilder.model.JSTarget {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.JSTarget =
      software.amazon.awssdk.services.amplifyuibuilder.model.JSTarget.UNKNOWN_TO_SDK_VERSION
  }
  case object es2015 extends zio.aws.amplifyuibuilder.model.JSTarget {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.JSTarget =
      software.amazon.awssdk.services.amplifyuibuilder.model.JSTarget.ES2015
  }
  case object es2020 extends zio.aws.amplifyuibuilder.model.JSTarget {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.JSTarget =
      software.amazon.awssdk.services.amplifyuibuilder.model.JSTarget.ES2020
  }
}
