package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{Uuid, AppId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetCodegenJobRequest(
    appId: AppId,
    environmentName: String,
    id: Uuid
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.GetCodegenJobRequest = {
    import GetCodegenJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.GetCodegenJobRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .environmentName(environmentName: java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.GetCodegenJobRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.GetCodegenJobRequest.wrap(buildAwsValue())
}
object GetCodegenJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.GetCodegenJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.GetCodegenJobRequest =
      zio.aws.amplifyuibuilder.model
        .GetCodegenJobRequest(appId, environmentName, id)
    def appId: AppId
    def environmentName: String
    def id: Uuid
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.GetCodegenJobRequest
  ) extends zio.aws.amplifyuibuilder.model.GetCodegenJobRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplifyuibuilder.model.primitives.AppId(impl.appId())
    override val environmentName: String = impl.environmentName(): String
    override val id: Uuid =
      zio.aws.amplifyuibuilder.model.primitives.Uuid(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.GetCodegenJobRequest
  ): zio.aws.amplifyuibuilder.model.GetCodegenJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
