package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FieldConfig(
    excluded: Optional[Boolean] = Optional.Absent,
    inputType: Optional[zio.aws.amplifyuibuilder.model.FieldInputConfig] =
      Optional.Absent,
    label: Optional[String] = Optional.Absent,
    position: Optional[zio.aws.amplifyuibuilder.model.FieldPosition] =
      Optional.Absent,
    validations: Optional[
      Iterable[zio.aws.amplifyuibuilder.model.FieldValidationConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.FieldConfig = {
    import FieldConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.FieldConfig
      .builder()
      .optionallyWith(excluded.map(value => value: java.lang.Boolean))(
        _.excluded
      )
      .optionallyWith(inputType.map(value => value.buildAwsValue()))(
        _.inputType
      )
      .optionallyWith(label.map(value => value: java.lang.String))(_.label)
      .optionallyWith(position.map(value => value.buildAwsValue()))(_.position)
      .optionallyWith(
        validations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validations)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly =
    zio.aws.amplifyuibuilder.model.FieldConfig.wrap(buildAwsValue())
}
object FieldConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.FieldConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.FieldConfig =
      zio.aws.amplifyuibuilder.model.FieldConfig(
        excluded.map(value => value),
        inputType.map(value => value.asEditable),
        label.map(value => value),
        position.map(value => value.asEditable),
        validations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def excluded: Optional[Boolean]
    def inputType
        : Optional[zio.aws.amplifyuibuilder.model.FieldInputConfig.ReadOnly]
    def label: Optional[String]
    def position
        : Optional[zio.aws.amplifyuibuilder.model.FieldPosition.ReadOnly]
    def validations: Optional[
      List[zio.aws.amplifyuibuilder.model.FieldValidationConfiguration.ReadOnly]
    ]
    def getExcluded: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("excluded", excluded)
    def getInputType: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.FieldInputConfig.ReadOnly
    ] = AwsError.unwrapOptionField("inputType", inputType)
    def getLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("label", label)
    def getPosition: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.FieldPosition.ReadOnly
    ] = AwsError.unwrapOptionField("position", position)
    def getValidations: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.FieldValidationConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("validations", validations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FieldConfig
  ) extends zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly {
    override val excluded: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.excluded())
      .map(value => value: Boolean)
    override val inputType
        : Optional[zio.aws.amplifyuibuilder.model.FieldInputConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputType())
        .map(value =>
          zio.aws.amplifyuibuilder.model.FieldInputConfig.wrap(value)
        )
    override val label: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => value: String)
    override val position
        : Optional[zio.aws.amplifyuibuilder.model.FieldPosition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.position())
        .map(value => zio.aws.amplifyuibuilder.model.FieldPosition.wrap(value))
    override val validations: Optional[
      List[zio.aws.amplifyuibuilder.model.FieldValidationConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.validations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplifyuibuilder.model.FieldValidationConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FieldConfig
  ): zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly = new Wrapper(impl)
}
