package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.FormName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateFormData(
    cta: Optional[zio.aws.amplifyuibuilder.model.FormCTA] = Optional.Absent,
    dataType: Optional[zio.aws.amplifyuibuilder.model.FormDataTypeConfig] =
      Optional.Absent,
    fields: Optional[Map[String, zio.aws.amplifyuibuilder.model.FieldConfig]] =
      Optional.Absent,
    formActionType: Optional[zio.aws.amplifyuibuilder.model.FormActionType] =
      Optional.Absent,
    name: Optional[FormName] = Optional.Absent,
    schemaVersion: Optional[String] = Optional.Absent,
    sectionalElements: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.SectionalElement]
    ] = Optional.Absent,
    style: Optional[zio.aws.amplifyuibuilder.model.FormStyle] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormData = {
    import UpdateFormData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormData
      .builder()
      .optionallyWith(cta.map(value => value.buildAwsValue()))(_.cta)
      .optionallyWith(dataType.map(value => value.buildAwsValue()))(_.dataType)
      .optionallyWith(
        fields.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.fields)
      .optionallyWith(formActionType.map(value => value.unwrap))(
        _.formActionType
      )
      .optionallyWith(
        name.map(value => FormName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(schemaVersion.map(value => value: java.lang.String))(
        _.schemaVersion
      )
      .optionallyWith(
        sectionalElements.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.sectionalElements)
      .optionallyWith(style.map(value => value.buildAwsValue()))(_.style)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.UpdateFormData.ReadOnly =
    zio.aws.amplifyuibuilder.model.UpdateFormData.wrap(buildAwsValue())
}
object UpdateFormData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.UpdateFormData =
      zio.aws.amplifyuibuilder.model.UpdateFormData(
        cta.map(value => value.asEditable),
        dataType.map(value => value.asEditable),
        fields.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        formActionType.map(value => value),
        name.map(value => value),
        schemaVersion.map(value => value),
        sectionalElements.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        style.map(value => value.asEditable)
      )
    def cta: Optional[zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly]
    def dataType
        : Optional[zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly]
    def fields: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly]
    ]
    def formActionType: Optional[zio.aws.amplifyuibuilder.model.FormActionType]
    def name: Optional[FormName]
    def schemaVersion: Optional[String]
    def sectionalElements: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly]
    ]
    def style: Optional[zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly]
    def getCta
        : ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly] =
      AwsError.unwrapOptionField("cta", cta)
    def getDataType: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dataType", dataType)
    def getFields: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("fields", fields)
    def getFormActionType
        : ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.FormActionType] =
      AwsError.unwrapOptionField("formActionType", formActionType)
    def getName: ZIO[Any, AwsError, FormName] =
      AwsError.unwrapOptionField("name", name)
    def getSchemaVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getSectionalElements: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly
    ]] = AwsError.unwrapOptionField("sectionalElements", sectionalElements)
    def getStyle: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly
    ] = AwsError.unwrapOptionField("style", style)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormData
  ) extends zio.aws.amplifyuibuilder.model.UpdateFormData.ReadOnly {
    override val cta
        : Optional[zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cta())
        .map(value => zio.aws.amplifyuibuilder.model.FormCTA.wrap(value))
    override val dataType
        : Optional[zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataType())
        .map(value =>
          zio.aws.amplifyuibuilder.model.FormDataTypeConfig.wrap(value)
        )
    override val fields: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fields())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.FieldConfig
              .wrap(value)
          })
          .toMap
      )
    override val formActionType
        : Optional[zio.aws.amplifyuibuilder.model.FormActionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formActionType())
        .map(value => zio.aws.amplifyuibuilder.model.FormActionType.wrap(value))
    override val name: Optional[FormName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.amplifyuibuilder.model.primitives.FormName(value))
    override val schemaVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaVersion())
      .map(value => value: String)
    override val sectionalElements: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sectionalElements())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.SectionalElement
              .wrap(value)
          })
          .toMap
      )
    override val style
        : Optional[zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.style())
        .map(value => zio.aws.amplifyuibuilder.model.FormStyle.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormData
  ): zio.aws.amplifyuibuilder.model.UpdateFormData.ReadOnly = new Wrapper(impl)
}
