package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMetadataRequest(appId: String, environmentName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.GetMetadataRequest = {
    import GetMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.GetMetadataRequest
      .builder()
      .appId(appId: java.lang.String)
      .environmentName(environmentName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.GetMetadataRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.GetMetadataRequest.wrap(buildAwsValue())
}
object GetMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.GetMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.GetMetadataRequest =
      zio.aws.amplifyuibuilder.model.GetMetadataRequest(appId, environmentName)
    def appId: String
    def environmentName: String
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.GetMetadataRequest
  ) extends zio.aws.amplifyuibuilder.model.GetMetadataRequest.ReadOnly {
    override val appId: String = impl.appId(): String
    override val environmentName: String = impl.environmentName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.GetMetadataRequest
  ): zio.aws.amplifyuibuilder.model.GetMetadataRequest.ReadOnly = new Wrapper(
    impl
  )
}
