package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFormResponse(
    entity: Optional[zio.aws.amplifyuibuilder.model.Form] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormResponse = {
    import CreateFormResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormResponse
      .builder()
      .optionallyWith(entity.map(value => value.buildAwsValue()))(_.entity)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.CreateFormResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.CreateFormResponse.wrap(buildAwsValue())
}
object CreateFormResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.CreateFormResponse =
      zio.aws.amplifyuibuilder.model
        .CreateFormResponse(entity.map(value => value.asEditable))
    def entity: Optional[zio.aws.amplifyuibuilder.model.Form.ReadOnly]
    def getEntity
        : ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.Form.ReadOnly] =
      AwsError.unwrapOptionField("entity", entity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormResponse
  ) extends zio.aws.amplifyuibuilder.model.CreateFormResponse.ReadOnly {
    override val entity
        : Optional[zio.aws.amplifyuibuilder.model.Form.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entity())
        .map(value => zio.aws.amplifyuibuilder.model.Form.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormResponse
  ): zio.aws.amplifyuibuilder.model.CreateFormResponse.ReadOnly = new Wrapper(
    impl
  )
}
