package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FieldPosition(
    below: Optional[String] = Optional.Absent,
    fixed: Optional[zio.aws.amplifyuibuilder.model.FixedPosition] =
      Optional.Absent,
    rightOf: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.FieldPosition = {
    import FieldPosition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.FieldPosition
      .builder()
      .optionallyWith(below.map(value => value: java.lang.String))(_.below)
      .optionallyWith(fixed.map(value => value.unwrap))(_.fixed)
      .optionallyWith(rightOf.map(value => value: java.lang.String))(_.rightOf)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.FieldPosition.ReadOnly =
    zio.aws.amplifyuibuilder.model.FieldPosition.wrap(buildAwsValue())
}
object FieldPosition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.FieldPosition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.FieldPosition =
      zio.aws.amplifyuibuilder.model.FieldPosition(
        below.map(value => value),
        fixed.map(value => value),
        rightOf.map(value => value)
      )
    def below: Optional[String]
    def fixed: Optional[zio.aws.amplifyuibuilder.model.FixedPosition]
    def rightOf: Optional[String]
    def getBelow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("below", below)
    def getFixed
        : ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.FixedPosition] =
      AwsError.unwrapOptionField("fixed", fixed)
    def getRightOf: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rightOf", rightOf)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FieldPosition
  ) extends zio.aws.amplifyuibuilder.model.FieldPosition.ReadOnly {
    override val below: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.below())
      .map(value => value: String)
    override val fixed: Optional[zio.aws.amplifyuibuilder.model.FixedPosition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fixed())
        .map(value => zio.aws.amplifyuibuilder.model.FixedPosition.wrap(value))
    override val rightOf: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.rightOf())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FieldPosition
  ): zio.aws.amplifyuibuilder.model.FieldPosition.ReadOnly = new Wrapper(impl)
}
