package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateFormRequest(
    appId: String,
    clientToken: Optional[String] = Optional.Absent,
    environmentName: String,
    id: Uuid,
    updatedForm: zio.aws.amplifyuibuilder.model.UpdateFormData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormRequest = {
    import UpdateFormRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormRequest
      .builder()
      .appId(appId: java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .environmentName(environmentName: java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .updatedForm(updatedForm.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.UpdateFormRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.UpdateFormRequest.wrap(buildAwsValue())
}
object UpdateFormRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.UpdateFormRequest =
      zio.aws.amplifyuibuilder.model.UpdateFormRequest(
        appId,
        clientToken.map(value => value),
        environmentName,
        id,
        updatedForm.asEditable
      )
    def appId: String
    def clientToken: Optional[String]
    def environmentName: String
    def id: Uuid
    def updatedForm: zio.aws.amplifyuibuilder.model.UpdateFormData.ReadOnly
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getUpdatedForm: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.UpdateFormData.ReadOnly
    ] = ZIO.succeed(updatedForm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormRequest
  ) extends zio.aws.amplifyuibuilder.model.UpdateFormRequest.ReadOnly {
    override val appId: String = impl.appId(): String
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val environmentName: String = impl.environmentName(): String
    override val id: Uuid =
      zio.aws.amplifyuibuilder.model.primitives.Uuid(impl.id())
    override val updatedForm
        : zio.aws.amplifyuibuilder.model.UpdateFormData.ReadOnly =
      zio.aws.amplifyuibuilder.model.UpdateFormData.wrap(impl.updatedForm())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormRequest
  ): zio.aws.amplifyuibuilder.model.UpdateFormRequest.ReadOnly = new Wrapper(
    impl
  )
}
