package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FieldValidationConfiguration(
    numValues: Optional[Iterable[Integer]] = Optional.Absent,
    strValues: Optional[Iterable[String]] = Optional.Absent,
    `type`: String,
    validationMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.FieldValidationConfiguration = {
    import FieldValidationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.FieldValidationConfiguration
      .builder()
      .optionallyWith(
        numValues.map(value =>
          value.map { item =>
            item: java.lang.Integer
          }.asJavaCollection
        )
      )(_.numValues)
      .optionallyWith(
        strValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.strValues)
      .`type`(`type`: java.lang.String)
      .optionallyWith(validationMessage.map(value => value: java.lang.String))(
        _.validationMessage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.FieldValidationConfiguration.ReadOnly =
    zio.aws.amplifyuibuilder.model.FieldValidationConfiguration
      .wrap(buildAwsValue())
}
object FieldValidationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.FieldValidationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifyuibuilder.model.FieldValidationConfiguration =
      zio.aws.amplifyuibuilder.model.FieldValidationConfiguration(
        numValues.map(value => value),
        strValues.map(value => value),
        `type`,
        validationMessage.map(value => value)
      )
    def numValues: Optional[List[Integer]]
    def strValues: Optional[List[String]]
    def `type`: String
    def validationMessage: Optional[String]
    def getNumValues: ZIO[Any, AwsError, List[Integer]] =
      AwsError.unwrapOptionField("numValues", numValues)
    def getStrValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("strValues", strValues)
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
    def getValidationMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("validationMessage", validationMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FieldValidationConfiguration
  ) extends zio.aws.amplifyuibuilder.model.FieldValidationConfiguration.ReadOnly {
    override val numValues: Optional[List[Integer]] = zio.aws.core.internal
      .optionalFromNullable(impl.numValues())
      .map(value =>
        value.asScala.map { item =>
          item: Integer
        }.toList
      )
    override val strValues: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.strValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val `type`: String = impl.`type`(): String
    override val validationMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.validationMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FieldValidationConfiguration
  ): zio.aws.amplifyuibuilder.model.FieldValidationConfiguration.ReadOnly =
    new Wrapper(impl)
}
