package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{FormName, Uuid}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class FormSummary(
    appId: String,
    dataType: zio.aws.amplifyuibuilder.model.FormDataTypeConfig,
    environmentName: String,
    formActionType: zio.aws.amplifyuibuilder.model.FormActionType,
    id: Uuid,
    name: FormName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.FormSummary = {
    import FormSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.FormSummary
      .builder()
      .appId(appId: java.lang.String)
      .dataType(dataType.buildAwsValue())
      .environmentName(environmentName: java.lang.String)
      .formActionType(formActionType.unwrap)
      .id(Uuid.unwrap(id): java.lang.String)
      .name(FormName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.FormSummary.ReadOnly =
    zio.aws.amplifyuibuilder.model.FormSummary.wrap(buildAwsValue())
}
object FormSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.FormSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.FormSummary =
      zio.aws.amplifyuibuilder.model.FormSummary(
        appId,
        dataType.asEditable,
        environmentName,
        formActionType,
        id,
        name
      )
    def appId: String
    def dataType: zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly
    def environmentName: String
    def formActionType: zio.aws.amplifyuibuilder.model.FormActionType
    def id: Uuid
    def name: FormName
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getDataType: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly
    ] = ZIO.succeed(dataType)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getFormActionType
        : ZIO[Any, Nothing, zio.aws.amplifyuibuilder.model.FormActionType] =
      ZIO.succeed(formActionType)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, FormName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FormSummary
  ) extends zio.aws.amplifyuibuilder.model.FormSummary.ReadOnly {
    override val appId: String = impl.appId(): String
    override val dataType
        : zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly =
      zio.aws.amplifyuibuilder.model.FormDataTypeConfig.wrap(impl.dataType())
    override val environmentName: String = impl.environmentName(): String
    override val formActionType: zio.aws.amplifyuibuilder.model.FormActionType =
      zio.aws.amplifyuibuilder.model.FormActionType.wrap(impl.formActionType())
    override val id: Uuid =
      zio.aws.amplifyuibuilder.model.primitives.Uuid(impl.id())
    override val name: FormName =
      zio.aws.amplifyuibuilder.model.primitives.FormName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FormSummary
  ): zio.aws.amplifyuibuilder.model.FormSummary.ReadOnly = new Wrapper(impl)
}
