package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFormRequest(
    appId: String,
    clientToken: Optional[String] = Optional.Absent,
    environmentName: String,
    formToCreate: zio.aws.amplifyuibuilder.model.CreateFormData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormRequest = {
    import CreateFormRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormRequest
      .builder()
      .appId(appId: java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .environmentName(environmentName: java.lang.String)
      .formToCreate(formToCreate.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.CreateFormRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.CreateFormRequest.wrap(buildAwsValue())
}
object CreateFormRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.CreateFormRequest =
      zio.aws.amplifyuibuilder.model.CreateFormRequest(
        appId,
        clientToken.map(value => value),
        environmentName,
        formToCreate.asEditable
      )
    def appId: String
    def clientToken: Optional[String]
    def environmentName: String
    def formToCreate: zio.aws.amplifyuibuilder.model.CreateFormData.ReadOnly
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getFormToCreate: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.CreateFormData.ReadOnly
    ] = ZIO.succeed(formToCreate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormRequest
  ) extends zio.aws.amplifyuibuilder.model.CreateFormRequest.ReadOnly {
    override val appId: String = impl.appId(): String
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val environmentName: String = impl.environmentName(): String
    override val formToCreate
        : zio.aws.amplifyuibuilder.model.CreateFormData.ReadOnly =
      zio.aws.amplifyuibuilder.model.CreateFormData.wrap(impl.formToCreate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormRequest
  ): zio.aws.amplifyuibuilder.model.CreateFormRequest.ReadOnly = new Wrapper(
    impl
  )
}
