package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComponentVariant(
    overrides: Optional[Map[String, Map[String, String]]] = Optional.Absent,
    variantValues: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ComponentVariant = {
    import ComponentVariant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentVariant
      .builder()
      .optionallyWith(
        overrides.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value
                .map({ case (key, value) =>
                  (key: java.lang.String) -> (value: java.lang.String)
                })
                .asJava
            })
            .asJava
        )
      )(_.overrides)
      .optionallyWith(
        variantValues.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.variantValues)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ComponentVariant.ReadOnly =
    zio.aws.amplifyuibuilder.model.ComponentVariant.wrap(buildAwsValue())
}
object ComponentVariant {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentVariant
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ComponentVariant =
      zio.aws.amplifyuibuilder.model.ComponentVariant(
        overrides.map(value => value),
        variantValues.map(value => value)
      )
    def overrides: Optional[Map[String, Map[String, String]]]
    def variantValues: Optional[Map[String, String]]
    def getOverrides: ZIO[Any, AwsError, Map[String, Map[String, String]]] =
      AwsError.unwrapOptionField("overrides", overrides)
    def getVariantValues: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("variantValues", variantValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentVariant
  ) extends zio.aws.amplifyuibuilder.model.ComponentVariant.ReadOnly {
    override val overrides: Optional[Map[String, Map[String, String]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overrides())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> value.asScala
                .map({ case (key, value) =>
                  (key: String) -> (value: String)
                })
                .toMap
            })
            .toMap
        )
    override val variantValues: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.variantValues())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentVariant
  ): zio.aws.amplifyuibuilder.model.ComponentVariant.ReadOnly = new Wrapper(
    impl
  )
}
