package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ValueMapping(
    displayValue: Optional[
      zio.aws.amplifyuibuilder.model.FormInputValueProperty
    ] = Optional.Absent,
    value: zio.aws.amplifyuibuilder.model.FormInputValueProperty
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ValueMapping = {
    import ValueMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ValueMapping
      .builder()
      .optionallyWith(displayValue.map(value => value.buildAwsValue()))(
        _.displayValue
      )
      .value(value.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ValueMapping.ReadOnly =
    zio.aws.amplifyuibuilder.model.ValueMapping.wrap(buildAwsValue())
}
object ValueMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ValueMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ValueMapping =
      zio.aws.amplifyuibuilder.model.ValueMapping(
        displayValue.map(value => value.asEditable),
        value.asEditable
      )
    def displayValue: Optional[
      zio.aws.amplifyuibuilder.model.FormInputValueProperty.ReadOnly
    ]
    def value: zio.aws.amplifyuibuilder.model.FormInputValueProperty.ReadOnly
    def getDisplayValue: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.FormInputValueProperty.ReadOnly
    ] = AwsError.unwrapOptionField("displayValue", displayValue)
    def getValue: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.FormInputValueProperty.ReadOnly
    ] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ValueMapping
  ) extends zio.aws.amplifyuibuilder.model.ValueMapping.ReadOnly {
    override val displayValue: Optional[
      zio.aws.amplifyuibuilder.model.FormInputValueProperty.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.displayValue())
      .map(value =>
        zio.aws.amplifyuibuilder.model.FormInputValueProperty.wrap(value)
      )
    override val value
        : zio.aws.amplifyuibuilder.model.FormInputValueProperty.ReadOnly =
      zio.aws.amplifyuibuilder.model.FormInputValueProperty.wrap(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ValueMapping
  ): zio.aws.amplifyuibuilder.model.ValueMapping.ReadOnly = new Wrapper(impl)
}
