package zio.aws.amplifyuibuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.amplifyuibuilder.model.primitives.ListThemesLimit
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListThemesRequest(
    appId: String,
    environmentName: String,
    maxResults: Optional[ListThemesLimit] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest = {
    import ListThemesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest
      .builder()
      .appId(appId: java.lang.String)
      .environmentName(environmentName: java.lang.String)
      .optionallyWith(
        maxResults.map(value => ListThemesLimit.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ListThemesRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.ListThemesRequest.wrap(buildAwsValue())
}
object ListThemesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ListThemesRequest =
      zio.aws.amplifyuibuilder.model.ListThemesRequest(
        appId,
        environmentName,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def appId: String
    def environmentName: String
    def maxResults: Optional[ListThemesLimit]
    def nextToken: Optional[String]
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getMaxResults: ZIO[Any, AwsError, ListThemesLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest
  ) extends zio.aws.amplifyuibuilder.model.ListThemesRequest.ReadOnly {
    override val appId: String = impl.appId(): String
    override val environmentName: String = impl.environmentName(): String
    override val maxResults: Optional[ListThemesLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.amplifyuibuilder.model.primitives.ListThemesLimit(value)
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest
  ): zio.aws.amplifyuibuilder.model.ListThemesRequest.ReadOnly = new Wrapper(
    impl
  )
}
