package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ExchangeCodeForTokenRequest(
    provider: zio.aws.amplifyuibuilder.model.TokenProviders,
    request: zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequestBody
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenRequest = {
    import ExchangeCodeForTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenRequest
      .builder()
      .provider(provider.unwrap)
      .request(request.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequest
      .wrap(buildAwsValue())
}
object ExchangeCodeForTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequest =
      zio.aws.amplifyuibuilder.model
        .ExchangeCodeForTokenRequest(provider, request.asEditable)
    def provider: zio.aws.amplifyuibuilder.model.TokenProviders
    def request: zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequestBody.ReadOnly
    def getProvider
        : ZIO[Any, Nothing, zio.aws.amplifyuibuilder.model.TokenProviders] =
      ZIO.succeed(provider)
    def getRequest: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequestBody.ReadOnly
    ] = ZIO.succeed(request)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenRequest
  ) extends zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequest.ReadOnly {
    override val provider: zio.aws.amplifyuibuilder.model.TokenProviders =
      zio.aws.amplifyuibuilder.model.TokenProviders.wrap(impl.provider())
    override val request
        : zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequestBody.ReadOnly =
      zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequestBody
        .wrap(impl.request())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenRequest
  ): zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequest.ReadOnly =
    new Wrapper(impl)
}
