package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExportComponentsResponse(
    entities: Iterable[zio.aws.amplifyuibuilder.model.Component],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse = {
    import ExportComponentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse
      .builder()
      .entities(entities.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ExportComponentsResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.ExportComponentsResponse
      .wrap(buildAwsValue())
}
object ExportComponentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ExportComponentsResponse =
      zio.aws.amplifyuibuilder.model.ExportComponentsResponse(
        entities.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def entities: List[zio.aws.amplifyuibuilder.model.Component.ReadOnly]
    def nextToken: Optional[String]
    def getEntities: ZIO[Any, Nothing, List[
      zio.aws.amplifyuibuilder.model.Component.ReadOnly
    ]] = ZIO.succeed(entities)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse
  ) extends zio.aws.amplifyuibuilder.model.ExportComponentsResponse.ReadOnly {
    override val entities
        : List[zio.aws.amplifyuibuilder.model.Component.ReadOnly] = impl
      .entities()
      .asScala
      .map { item =>
        zio.aws.amplifyuibuilder.model.Component.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse
  ): zio.aws.amplifyuibuilder.model.ExportComponentsResponse.ReadOnly =
    new Wrapper(impl)
}
