package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{
  TagValue,
  TagKey,
  ComponentName,
  ComponentType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateComponentData(
    bindingProperties: Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue
    ],
    children: Optional[
      Iterable[zio.aws.amplifyuibuilder.model.ComponentChild]
    ] = Optional.Absent,
    collectionProperties: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentDataConfiguration]
    ] = Optional.Absent,
    componentType: ComponentType,
    events: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentEvent]
    ] = Optional.Absent,
    name: ComponentName,
    overrides: Map[String, Map[String, String]],
    properties: Map[String, zio.aws.amplifyuibuilder.model.ComponentProperty],
    schemaVersion: Optional[String] = Optional.Absent,
    sourceId: Optional[String] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    variants: Iterable[zio.aws.amplifyuibuilder.model.ComponentVariant]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentData = {
    import CreateComponentData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentData
      .builder()
      .bindingProperties(
        bindingProperties
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .optionallyWith(
        children.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.children)
      .optionallyWith(
        collectionProperties.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.collectionProperties)
      .componentType(ComponentType.unwrap(componentType): java.lang.String)
      .optionallyWith(
        events.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.events)
      .name(ComponentName.unwrap(name): java.lang.String)
      .overrides(
        overrides
          .map({ case (key, value) =>
            (key: java.lang.String) -> value
              .map({ case (key, value) =>
                (key: java.lang.String) -> (value: java.lang.String)
              })
              .asJava
          })
          .asJava
      )
      .properties(
        properties
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .optionallyWith(schemaVersion.map(value => value: java.lang.String))(
        _.schemaVersion
      )
      .optionallyWith(sourceId.map(value => value: java.lang.String))(
        _.sourceId
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .variants(variants.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.CreateComponentData.ReadOnly =
    zio.aws.amplifyuibuilder.model.CreateComponentData.wrap(buildAwsValue())
}
object CreateComponentData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.CreateComponentData =
      zio.aws.amplifyuibuilder.model.CreateComponentData(
        bindingProperties.map({ case (key, value) =>
          key -> value.asEditable
        }),
        children.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        collectionProperties.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        componentType,
        events.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        name,
        overrides,
        properties.map({ case (key, value) =>
          key -> value.asEditable
        }),
        schemaVersion.map(value => value),
        sourceId.map(value => value),
        tags.map(value => value),
        variants.map { item =>
          item.asEditable
        }
      )
    def bindingProperties: Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly
    ]
    def children
        : Optional[List[zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly]]
    def collectionProperties: Optional[Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly
    ]]
    def componentType: ComponentType
    def events: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentEvent.ReadOnly]
    ]
    def name: ComponentName
    def overrides: Map[String, Map[String, String]]
    def properties
        : Map[String, zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    def schemaVersion: Optional[String]
    def sourceId: Optional[String]
    def tags: Optional[Map[TagKey, TagValue]]
    def variants: List[zio.aws.amplifyuibuilder.model.ComponentVariant.ReadOnly]
    def getBindingProperties: ZIO[Any, Nothing, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly
    ]] = ZIO.succeed(bindingProperties)
    def getChildren: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly
    ]] = AwsError.unwrapOptionField("children", children)
    def getCollectionProperties: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("collectionProperties", collectionProperties)
    def getComponentType: ZIO[Any, Nothing, ComponentType] =
      ZIO.succeed(componentType)
    def getEvents: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("events", events)
    def getName: ZIO[Any, Nothing, ComponentName] = ZIO.succeed(name)
    def getOverrides: ZIO[Any, Nothing, Map[String, Map[String, String]]] =
      ZIO.succeed(overrides)
    def getProperties: ZIO[Any, Nothing, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ]] = ZIO.succeed(properties)
    def getSchemaVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getSourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceId", sourceId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVariants: ZIO[Any, Nothing, List[
      zio.aws.amplifyuibuilder.model.ComponentVariant.ReadOnly
    ]] = ZIO.succeed(variants)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentData
  ) extends zio.aws.amplifyuibuilder.model.CreateComponentData.ReadOnly {
    override val bindingProperties: Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly
    ] = impl
      .bindingProperties()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue
          .wrap(value)
      })
      .toMap
    override val children: Optional[
      List[zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.children())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplifyuibuilder.model.ComponentChild.wrap(item)
        }.toList
      )
    override val collectionProperties: Optional[Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.collectionProperties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.ComponentDataConfiguration
              .wrap(value)
          })
          .toMap
      )
    override val componentType: ComponentType =
      zio.aws.amplifyuibuilder.model.primitives
        .ComponentType(impl.componentType())
    override val events: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentEvent.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.events())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.ComponentEvent
              .wrap(value)
          })
          .toMap
      )
    override val name: ComponentName =
      zio.aws.amplifyuibuilder.model.primitives.ComponentName(impl.name())
    override val overrides: Map[String, Map[String, String]] = impl
      .overrides()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      })
      .toMap
    override val properties: Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ] = impl
      .properties()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.amplifyuibuilder.model.ComponentProperty
          .wrap(value)
      })
      .toMap
    override val schemaVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaVersion())
      .map(value => value: String)
    override val sourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceId())
      .map(value => value: String)
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplifyuibuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.amplifyuibuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val variants
        : List[zio.aws.amplifyuibuilder.model.ComponentVariant.ReadOnly] = impl
      .variants()
      .asScala
      .map { item =>
        zio.aws.amplifyuibuilder.model.ComponentVariant.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentData
  ): zio.aws.amplifyuibuilder.model.CreateComponentData.ReadOnly = new Wrapper(
    impl
  )
}
