package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComponentProperty(
    bindingProperties: Optional[
      zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties
    ] = Optional.Absent,
    bindings: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.FormBindingElement]
    ] = Optional.Absent,
    collectionBindingProperties: Optional[
      zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties
    ] = Optional.Absent,
    componentName: Optional[String] = Optional.Absent,
    concat: Optional[
      Iterable[zio.aws.amplifyuibuilder.model.ComponentProperty]
    ] = Optional.Absent,
    condition: Optional[
      zio.aws.amplifyuibuilder.model.ComponentConditionProperty
    ] = Optional.Absent,
    configured: Optional[Boolean] = Optional.Absent,
    defaultValue: Optional[String] = Optional.Absent,
    event: Optional[String] = Optional.Absent,
    importedValue: Optional[String] = Optional.Absent,
    model: Optional[String] = Optional.Absent,
    property: Optional[String] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent,
    userAttribute: Optional[String] = Optional.Absent,
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ComponentProperty = {
    import ComponentProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentProperty
      .builder()
      .optionallyWith(bindingProperties.map(value => value.buildAwsValue()))(
        _.bindingProperties
      )
      .optionallyWith(
        bindings.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.bindings)
      .optionallyWith(
        collectionBindingProperties.map(value => value.buildAwsValue())
      )(_.collectionBindingProperties)
      .optionallyWith(componentName.map(value => value: java.lang.String))(
        _.componentName
      )
      .optionallyWith(
        concat.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.concat)
      .optionallyWith(condition.map(value => value.buildAwsValue()))(
        _.condition
      )
      .optionallyWith(configured.map(value => value: java.lang.Boolean))(
        _.configured
      )
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .optionallyWith(event.map(value => value: java.lang.String))(_.event)
      .optionallyWith(importedValue.map(value => value: java.lang.String))(
        _.importedValue
      )
      .optionallyWith(model.map(value => value: java.lang.String))(_.model)
      .optionallyWith(property.map(value => value: java.lang.String))(
        _.property
      )
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(userAttribute.map(value => value: java.lang.String))(
        _.userAttribute
      )
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly =
    zio.aws.amplifyuibuilder.model.ComponentProperty.wrap(buildAwsValue())
}
object ComponentProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ComponentProperty =
      zio.aws.amplifyuibuilder.model.ComponentProperty(
        bindingProperties.map(value => value.asEditable),
        bindings.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        collectionBindingProperties.map(value => value.asEditable),
        componentName.map(value => value),
        concat.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        condition.map(value => value.asEditable),
        configured.map(value => value),
        defaultValue.map(value => value),
        event.map(value => value),
        importedValue.map(value => value),
        model.map(value => value),
        property.map(value => value),
        `type`.map(value => value),
        userAttribute.map(value => value),
        value.map(value => value)
      )
    def bindingProperties: Optional[
      zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties.ReadOnly
    ]
    def bindings: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.FormBindingElement.ReadOnly]
    ]
    def collectionBindingProperties: Optional[
      zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties.ReadOnly
    ]
    def componentName: Optional[String]
    def concat: Optional[
      List[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    ]
    def condition: Optional[
      zio.aws.amplifyuibuilder.model.ComponentConditionProperty.ReadOnly
    ]
    def configured: Optional[Boolean]
    def defaultValue: Optional[String]
    def event: Optional[String]
    def importedValue: Optional[String]
    def model: Optional[String]
    def property: Optional[String]
    def `type`: Optional[String]
    def userAttribute: Optional[String]
    def value: Optional[String]
    def getBindingProperties: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties.ReadOnly
    ] = AwsError.unwrapOptionField("bindingProperties", bindingProperties)
    def getBindings: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.FormBindingElement.ReadOnly
    ]] = AwsError.unwrapOptionField("bindings", bindings)
    def getCollectionBindingProperties: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "collectionBindingProperties",
      collectionBindingProperties
    )
    def getComponentName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("componentName", componentName)
    def getConcat: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("concat", concat)
    def getCondition: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentConditionProperty.ReadOnly
    ] = AwsError.unwrapOptionField("condition", condition)
    def getConfigured: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("configured", configured)
    def getDefaultValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getEvent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("event", event)
    def getImportedValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("importedValue", importedValue)
    def getModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("model", model)
    def getProperty: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("property", property)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getUserAttribute: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userAttribute", userAttribute)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentProperty
  ) extends zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly {
    override val bindingProperties: Optional[
      zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bindingProperties())
      .map(value =>
        zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties
          .wrap(value)
      )
    override val bindings: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.FormBindingElement.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bindings())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.FormBindingElement
              .wrap(value)
          })
          .toMap
      )
    override val collectionBindingProperties: Optional[
      zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.collectionBindingProperties())
      .map(value =>
        zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties
          .wrap(value)
      )
    override val componentName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.componentName())
      .map(value => value: String)
    override val concat: Optional[
      List[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.concat())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplifyuibuilder.model.ComponentProperty.wrap(item)
        }.toList
      )
    override val condition: Optional[
      zio.aws.amplifyuibuilder.model.ComponentConditionProperty.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.condition())
      .map(value =>
        zio.aws.amplifyuibuilder.model.ComponentConditionProperty.wrap(value)
      )
    override val configured: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.configured())
      .map(value => value: Boolean)
    override val defaultValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValue())
      .map(value => value: String)
    override val event: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.event())
      .map(value => value: String)
    override val importedValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.importedValue())
      .map(value => value: String)
    override val model: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.model())
      .map(value => value: String)
    override val property: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.property())
      .map(value => value: String)
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
    override val userAttribute: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userAttribute())
      .map(value => value: String)
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentProperty
  ): zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly = new Wrapper(
    impl
  )
}
