package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{
  Integer,
  SyntheticRefreshTokenResponseString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RefreshTokenResponse(
    accessToken: SyntheticRefreshTokenResponseString,
    expiresIn: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenResponse = {
    import RefreshTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenResponse
      .builder()
      .accessToken(
        SyntheticRefreshTokenResponseString.unwrap(
          accessToken
        ): java.lang.String
      )
      .expiresIn(expiresIn: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.RefreshTokenResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.RefreshTokenResponse.wrap(buildAwsValue())
}
object RefreshTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.RefreshTokenResponse =
      zio.aws.amplifyuibuilder.model
        .RefreshTokenResponse(accessToken, expiresIn)
    def accessToken: SyntheticRefreshTokenResponseString
    def expiresIn: Integer
    def getAccessToken: ZIO[Any, Nothing, SyntheticRefreshTokenResponseString] =
      ZIO.succeed(accessToken)
    def getExpiresIn: ZIO[Any, Nothing, Integer] = ZIO.succeed(expiresIn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenResponse
  ) extends zio.aws.amplifyuibuilder.model.RefreshTokenResponse.ReadOnly {
    override val accessToken: SyntheticRefreshTokenResponseString =
      zio.aws.amplifyuibuilder.model.primitives
        .SyntheticRefreshTokenResponseString(impl.accessToken())
    override val expiresIn: Integer = impl.expiresIn(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenResponse
  ): zio.aws.amplifyuibuilder.model.RefreshTokenResponse.ReadOnly = new Wrapper(
    impl
  )
}
