package zio.aws.amplifyuibuilder.model
import scala.jdk.CollectionConverters._
sealed trait TokenProviders {
  def unwrap
      : software.amazon.awssdk.services.amplifyuibuilder.model.TokenProviders
}
object TokenProviders {
  def wrap(
      value: software.amazon.awssdk.services.amplifyuibuilder.model.TokenProviders
  ): zio.aws.amplifyuibuilder.model.TokenProviders = value match {
    case software.amazon.awssdk.services.amplifyuibuilder.model.TokenProviders.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifyuibuilder.model.TokenProviders.FIGMA =>
      val r = figma
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.amplifyuibuilder.model.TokenProviders {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.TokenProviders =
      software.amazon.awssdk.services.amplifyuibuilder.model.TokenProviders.UNKNOWN_TO_SDK_VERSION
  }
  case object figma extends zio.aws.amplifyuibuilder.model.TokenProviders {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.TokenProviders =
      software.amazon.awssdk.services.amplifyuibuilder.model.TokenProviders.FIGMA
  }
}
