package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Predicate(
    and: Option[Iterable[zio.aws.amplifyuibuilder.model.Predicate]] = None,
    field: Option[String] = None,
    operand: Option[String] = None,
    operator: Option[String] = None,
    or: Option[Iterable[zio.aws.amplifyuibuilder.model.Predicate]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.Predicate = {
    import Predicate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.Predicate
      .builder()
      .optionallyWith(
        and.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.and)
      .optionallyWith(field.map(value => value: java.lang.String))(_.field)
      .optionallyWith(operand.map(value => value: java.lang.String))(_.operand)
      .optionallyWith(operator.map(value => value: java.lang.String))(
        _.operator
      )
      .optionallyWith(
        or.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.or)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.Predicate.ReadOnly =
    zio.aws.amplifyuibuilder.model.Predicate.wrap(buildAwsValue())
}
object Predicate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.Predicate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.Predicate =
      zio.aws.amplifyuibuilder.model.Predicate(
        and.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        field.map(value => value),
        operand.map(value => value),
        operator.map(value => value),
        or.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def and: Option[List[zio.aws.amplifyuibuilder.model.Predicate.ReadOnly]]
    def field: Option[String]
    def operand: Option[String]
    def operator: Option[String]
    def or: Option[List[zio.aws.amplifyuibuilder.model.Predicate.ReadOnly]]
    def getAnd: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.Predicate.ReadOnly
    ]] = AwsError.unwrapOptionField("and", and)
    def getField: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("field", field)
    def getOperand: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operand", operand)
    def getOperator: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operator", operator)
    def getOr: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.Predicate.ReadOnly
    ]] = AwsError.unwrapOptionField("or", or)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.Predicate
  ) extends zio.aws.amplifyuibuilder.model.Predicate.ReadOnly {
    override val and
        : Option[List[zio.aws.amplifyuibuilder.model.Predicate.ReadOnly]] =
      scala
        .Option(impl.and())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifyuibuilder.model.Predicate.wrap(item)
          }.toList
        )
    override val field: Option[String] =
      scala.Option(impl.field()).map(value => value: String)
    override val operand: Option[String] =
      scala.Option(impl.operand()).map(value => value: String)
    override val operator: Option[String] =
      scala.Option(impl.operator()).map(value => value: String)
    override val or
        : Option[List[zio.aws.amplifyuibuilder.model.Predicate.ReadOnly]] =
      scala
        .Option(impl.or())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifyuibuilder.model.Predicate.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.Predicate
  ): zio.aws.amplifyuibuilder.model.Predicate.ReadOnly = new Wrapper(impl)
}
