package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateComponentResponse(
    entity: Option[zio.aws.amplifyuibuilder.model.Component] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentResponse = {
    import UpdateComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentResponse
      .builder()
      .optionallyWith(entity.map(value => value.buildAwsValue()))(_.entity)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.UpdateComponentResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.UpdateComponentResponse.wrap(buildAwsValue())
}
object UpdateComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.UpdateComponentResponse =
      zio.aws.amplifyuibuilder.model
        .UpdateComponentResponse(entity.map(value => value.asEditable))
    def entity: Option[zio.aws.amplifyuibuilder.model.Component.ReadOnly]
    def getEntity: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.Component.ReadOnly
    ] = AwsError.unwrapOptionField("entity", entity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentResponse
  ) extends zio.aws.amplifyuibuilder.model.UpdateComponentResponse.ReadOnly {
    override val entity
        : Option[zio.aws.amplifyuibuilder.model.Component.ReadOnly] = scala
      .Option(impl.entity())
      .map(value => zio.aws.amplifyuibuilder.model.Component.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentResponse
  ): zio.aws.amplifyuibuilder.model.UpdateComponentResponse.ReadOnly =
    new Wrapper(impl)
}
